// Popup script for Coretax Bulk Downloader
document.addEventListener('DOMContentLoaded', function() {
    const extensionStatus = document.getElementById('extension-status');
    const selectedCount = document.getElementById('selected-count');
    const totalCount = document.getElementById('total-count');
    const selectAllBtn = document.getElementById('select-all-btn');
    const clearSelectionBtn = document.getElementById('clear-selection-btn');
    const downloadBtn = document.getElementById('download-btn');

    // Check if we're on the correct page
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        const currentTab = tabs[0];
        const isCoretaxPage = currentTab.url.includes('coretaxdjp.pajak.go.id');
        
        if (isCoretaxPage) {
            extensionStatus.textContent = 'Active';
            extensionStatus.className = 'status-value active';
            
            // Get current status from content script
            chrome.tabs.sendMessage(currentTab.id, {action: 'getStatus'}, function(response) {
                if (response) {
                    updateStatus(response);
                } else {
                    // Content script not ready yet
                    extensionStatus.textContent = 'Loading...';
                    extensionStatus.className = 'status-value';
                    
                    // Try again after a short delay
                    setTimeout(() => {
                        chrome.tabs.sendMessage(currentTab.id, {action: 'getStatus'}, function(response) {
                            if (response) {
                                updateStatus(response);
                            }
                        });
                    }, 1000);
                }
            });
        } else {
            extensionStatus.textContent = 'Inactive';
            extensionStatus.className = 'status-value inactive';
            selectedCount.textContent = '0';
            totalCount.textContent = '0';
        }
    });

    function updateStatus(status) {
        selectedCount.textContent = status.selectedCount || 0;
        totalCount.textContent = status.totalCount || 0;
        
        // Update button states
        downloadBtn.disabled = status.selectedCount === 0;
        if (status.selectedCount > 0) {
            downloadBtn.textContent = `📥 Download (${status.selectedCount})`;
        } else {
            downloadBtn.textContent = '📥 Download Selected';
        }
    }

    // Event listeners for popup buttons
    selectAllBtn.addEventListener('click', function() {
        chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
            chrome.tabs.sendMessage(tabs[0].id, {action: 'selectAll'});
        });
    });

    clearSelectionBtn.addEventListener('click', function() {
        chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
            chrome.tabs.sendMessage(tabs[0].id, {action: 'clearSelection'});
        });
    });

    downloadBtn.addEventListener('click', function() {
        chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
            chrome.tabs.sendMessage(tabs[0].id, {action: 'downloadSelected'});
        });
    });

    // Listen for status updates from content script
    chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
        if (request.action === 'statusUpdate') {
            updateStatus(request.data);
        }
    });

    // Refresh status every 2 seconds
    setInterval(() => {
        chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
            const currentTab = tabs[0];
            if (currentTab.url.includes('coretaxdjp.pajak.go.id')) {
                chrome.tabs.sendMessage(currentTab.id, {action: 'getStatus'}, function(response) {
                    if (response) {
                        updateStatus(response);
                    }
                });
            }
        });
    }, 2000);
});
