#!/bin/bash

# Script to convert SVG icons to PNG for Chrome extension
# Requires ImageMagick or Inkscape

echo "Converting SVG icons to PNG..."

# Check if ImageMagick is available
if command -v convert &> /dev/null; then
    echo "Using ImageMagick..."
    convert icon16.svg -background transparent icon16.png
    convert icon48.svg -background transparent icon48.png
    convert icon128.svg -background transparent icon128.png
elif command -v inkscape &> /dev/null; then
    echo "Using Inkscape..."
    inkscape --export-png=icon16.png --export-width=16 --export-height=16 icon16.svg
    inkscape --export-png=icon48.png --export-width=48 --export-height=48 icon48.svg
    inkscape --export-png=icon128.png --export-width=128 --export-height=128 icon128.svg
else
    echo "Error: Neither ImageMagick nor Inkscape found."
    echo "Please install one of them to convert SVG to PNG:"
    echo "  - ImageMagick: brew install imagemagick"
    echo "  - Inkscape: brew install inkscape"
    echo ""
    echo "Or manually convert the SVG files to PNG with the correct dimensions."
    exit 1
fi

echo "Icon conversion completed!"
echo "Files created:"
echo "  - icon16.png (16x16)"
echo "  - icon48.png (48x48)" 
echo "  - icon128.png (128x128)"
