# Coretax Document Bulk Downloader

Chrome extension yang menambahkan fitur select dan bulk download untuk dokumen di portal Coretax.

## Fitur

- ✅ **Select All**: Pilih semua dokumen sekaligus
- ✅ **Individual Selection**: Pilih dokumen satu per satu
- ✅ **Bulk Download**: Download semua dokumen yang dipilih
- ✅ **Download Queue**: Download dengan delay 1 detik antar file
- ✅ **Real-time Status**: Lihat jumlah dokumen yang dipilih
- ✅ **Popup Interface**: Kontrol melalui popup extension
- ✅ **Auto-refresh**: Otomatis mendeteksi perubahan halaman

## Cara Install

1. **Download Extension**
   - Download semua file extension ke folder `Coretax-Doc-Down`

2. **Load Extension di Chrome**
   - Buka Chrome dan pergi ke `chrome://extensions/`
   - Aktifkan "Developer mode" di pojok kanan atas
   - Klik "Load unpacked"
   - Pilih folder `Coretax-Doc-Down`

3. **Pin Extension**
   - Klik icon puzzle di toolbar Chrome
   - Pin extension "Coretax Document Bulk Downloader"

## Cara Penggunaan

1. **Buka Portal Coretax**
   - Login ke https://coretaxdjp.pajak.go.id/
   - Pergi ke halaman "Dokumen Saya"

2. **Pilih Dokumen**
   - Gunakan checkbox di sebelah kiri setiap dokumen
   - Atau klik "Select All" untuk memilih semua
   - Lihat jumlah dokumen yang dipilih di toolbar

3. **Download Bulk**
   - Klik tombol "Download Selected" di toolbar
   - Atau gunakan popup extension untuk kontrol tambahan
   - File akan didownload satu per satu dengan delay 1 detik

## File Extension

- `manifest.json` - Konfigurasi extension
- `content.js` - Script utama yang berjalan di halaman
- `popup.html` - Interface popup extension
- `popup.js` - Script untuk popup
- `styles.css` - Styling untuk UI extension
- `icon16.png`, `icon48.png`, `icon128.png` - Icon extension (PNG files ready)

## Troubleshooting

**Extension tidak muncul di halaman dokumen:**
- Pastikan Anda berada di halaman "Dokumen Saya"
- Refresh halaman dan coba lagi
- Periksa console browser untuk error

**Download tidak berfungsi:**
- Pastikan popup blocker tidak aktif
- Coba download satu file dulu untuk memastikan login masih valid
- Periksa permission extension di chrome://extensions/

**Checkbox tidak muncul:**
- Refresh halaman
- Pastikan extension sudah di-load dengan benar
- Periksa apakah ada error di console

## Catatan Penting

- Extension hanya bekerja di domain coretaxdjp.pajak.go.id
- Download dilakukan dengan delay 1 detik antar file untuk menghindari overload server
- Extension akan otomatis mendeteksi perubahan halaman (SPA navigation)
- Status selection akan ter-reset saat pindah halaman

## Support

Jika ada masalah atau bug, silakan laporkan dengan detail:
- URL halaman yang bermasalah
- Error message di console browser
- Langkah-langkah yang menyebabkan masalah
